/*
 * Decompiled with CFR 0.152.
 */
package demos.util;

import demos.util.Time;

public class SystemTime
implements Time {
    private static final int DEFAULT_NUM_SMOOTHING_SAMPLES = 10;
    private long[] samples = new long[10];
    private int numSmoothingSamples;
    private int curSmoothingSample;
    private long baseTime = System.currentTimeMillis();
    private boolean hasCurTime;
    private double curTime;
    private double deltaT;

    public void setNumSmoothingSamples(int n) {
        this.samples = new long[n];
        this.numSmoothingSamples = 0;
        this.curSmoothingSample = 0;
        this.hasCurTime = false;
    }

    public int getNumSmoothingSamples() {
        return this.samples.length;
    }

    public void rebase() {
        this.baseTime = System.currentTimeMillis();
        this.setNumSmoothingSamples(this.samples.length);
    }

    @Override
    public void update() {
        long l;
        long l2 = System.currentTimeMillis();
        this.samples[this.curSmoothingSample] = l = l2 - this.baseTime;
        this.curSmoothingSample = (this.curSmoothingSample + 1) % this.samples.length;
        this.numSmoothingSamples = Math.min(1 + this.numSmoothingSamples, this.samples.length);
        double d = 0.0;
        for (int i = 0; i < this.numSmoothingSamples; ++i) {
            d += (double)this.samples[i];
        }
        d /= (double)(1000.0f * (float)this.numSmoothingSamples);
        double d2 = this.curTime;
        if (!this.hasCurTime) {
            d2 = d;
            this.hasCurTime = true;
        }
        this.deltaT = d - d2;
        this.curTime = d;
    }

    @Override
    public double time() {
        return this.curTime;
    }

    @Override
    public double deltaT() {
        return this.deltaT;
    }
}

