/*
 * Decompiled with CFR 0.152.
 */
package gleem;

import gleem.linalg.IntersectionPoint;
import gleem.linalg.Vec3f;

public class BSphere {
    private Vec3f center = new Vec3f();
    private float radius;
    private float radSq;

    public BSphere() {
        this.makeEmpty();
    }

    public BSphere(Vec3f vec3f, float f) {
        this.set(vec3f, f);
    }

    public void makeEmpty() {
        this.center.set(0.0f, 0.0f, 0.0f);
        this.radSq = 0.0f;
        this.radius = 0.0f;
    }

    public void setCenter(Vec3f vec3f) {
        this.center.set(vec3f);
    }

    public Vec3f getCenter() {
        return this.center;
    }

    public void setRadius(float f) {
        this.radius = f;
        this.radSq = f * f;
    }

    public float getRadius() {
        return this.radius;
    }

    public void set(Vec3f vec3f, float f) {
        this.setCenter(vec3f);
        this.setRadius(f);
    }

    float get(Vec3f vec3f) {
        vec3f.set(this.center);
        return this.radius;
    }

    public void extendBy(BSphere bSphere) {
        int n;
        if (this.radius == 0.0f || bSphere.radius == 0.0f) {
            return;
        }
        Vec3f vec3f = bSphere.center.minus(this.center);
        if (vec3f.lengthSquared() == 0.0f) {
            this.setRadius(Math.max(this.radius, bSphere.radius));
            return;
        }
        IntersectionPoint[] intersectionPointArray = new IntersectionPoint[4];
        for (n = 0; n < intersectionPointArray.length; ++n) {
            intersectionPointArray[n] = new IntersectionPoint();
        }
        n = this.intersectRay(this.center, vec3f, intersectionPointArray[0], intersectionPointArray[1]);
        assert (n == 2);
        n = this.intersectRay(this.center, vec3f, intersectionPointArray[2], intersectionPointArray[3]);
        assert (n == 2);
        IntersectionPoint intersectionPoint = intersectionPointArray[0];
        IntersectionPoint intersectionPoint2 = intersectionPointArray[0];
        for (int i = 0; i < 4; ++i) {
            if (intersectionPointArray[i].getT() < intersectionPoint.getT()) {
                intersectionPoint = intersectionPointArray[i];
                continue;
            }
            if (!(intersectionPointArray[i].getT() > intersectionPoint2.getT())) continue;
            intersectionPoint2 = intersectionPointArray[i];
        }
        this.center.add(intersectionPoint.getIntersectionPoint(), intersectionPoint2.getIntersectionPoint());
        this.center.scale(0.5f);
        this.setRadius(0.5f * intersectionPoint.getIntersectionPoint().minus(intersectionPoint2.getIntersectionPoint()).length());
    }

    int intersectRay(Vec3f vec3f, Vec3f vec3f2, IntersectionPoint intersectionPoint, IntersectionPoint intersectionPoint2) {
        Vec3f vec3f3;
        float f;
        float f2 = vec3f2.lengthSquared();
        if ((double)f2 == 0.0) {
            return 0;
        }
        float f3 = 2.0f * (vec3f.dot(vec3f2) - vec3f2.dot(this.center));
        float f4 = f3 * f3 - 4.0f * f2 * (f = (vec3f3 = this.center.minus(vec3f)).lengthSquared() - this.radSq);
        if (f4 < 0.0f) {
            return 0;
        }
        int n = f4 == 0.0f ? 1 : 2;
        intersectionPoint.setT(0.5f * (-1.0f * f3 + (float)Math.sqrt(f4)) / f2);
        if (n == 2) {
            intersectionPoint2.setT(0.5f * (-1.0f * f3 - (float)Math.sqrt(f4)) / f2);
        }
        Vec3f vec3f4 = new Vec3f(vec3f2);
        vec3f4.scale(intersectionPoint.getT());
        vec3f4.add(vec3f4, vec3f);
        intersectionPoint.setIntersectionPoint(vec3f4);
        if (n == 2) {
            vec3f4.set(vec3f2);
            vec3f4.scale(intersectionPoint2.getT());
            vec3f4.add(vec3f4, vec3f);
            intersectionPoint2.setIntersectionPoint(vec3f4);
        }
        return n;
    }
}

