/*
 * Decompiled with CFR 0.152.
 */
package gleem;

import com.jogamp.opengl.GL2;
import com.jogamp.opengl.GLAutoDrawable;
import com.jogamp.opengl.GLEventListener;
import com.jogamp.opengl.awt.AWTGLAutoDrawable;
import gleem.BSphere;
import gleem.BSphereProvider;
import gleem.CameraParameters;
import gleem.ManipManager;
import gleem.linalg.Mat4f;
import gleem.linalg.Rotf;
import gleem.linalg.Vec3f;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionAdapter;
import java.awt.event.MouseMotionListener;

public class ExaminerViewer {
    private AWTGLAutoDrawable window;
    private boolean interactionUnderway;
    private boolean iOwnInteraction;
    private boolean noAltKeyMode;
    private boolean autoRedrawMode = true;
    private boolean button1Down;
    private boolean button2Down;
    private boolean button3Down;
    private int lastX;
    private int lastY;
    private final float minFocalDist = 1.0f;
    private final Vec3f dolly = new Vec3f(0.0f, 0.0f, 10.0f);
    private final Vec3f center = new Vec3f(0.0f, 0.0f, 0.0f);
    private Rotf orientation = new Rotf();
    private Vec3f upVector = null;
    private float rotateSpeed = 1.0f;
    private final float minRotateSpeed = 1.0E-4f;
    private float dollySpeed = 2.0f;
    private final float minDollySpeed = 1.0E-4f;
    private float zNear = 1.0f;
    private float zFar = 100.0f;
    private float vertFOVScale = 1.0f;
    private final CameraParameters params = new CameraParameters();
    private BSphereProvider provider;
    private final MouseMotionAdapter mouseMotionListener = new MouseMotionAdapter(){

        @Override
        public void mouseDragged(MouseEvent mouseEvent) {
            ExaminerViewer.this.motionMethod(mouseEvent, mouseEvent.getX(), mouseEvent.getY());
        }

        @Override
        public void mouseMoved(MouseEvent mouseEvent) {
            if (ExaminerViewer.this.interactionUnderway && ExaminerViewer.this.iOwnInteraction) {
                ExaminerViewer.this.motionMethod(mouseEvent, mouseEvent.getX(), mouseEvent.getY());
            } else {
                ExaminerViewer.this.passiveMotionMethod(mouseEvent);
            }
        }
    };
    private final MouseAdapter mouseListener = new MouseAdapter(){

        @Override
        public void mousePressed(MouseEvent mouseEvent) {
            ExaminerViewer.this.mouseMethod(mouseEvent, mouseEvent.getModifiersEx(), true, mouseEvent.getX(), mouseEvent.getY());
        }

        @Override
        public void mouseReleased(MouseEvent mouseEvent) {
            ExaminerViewer.this.mouseMethod(mouseEvent, mouseEvent.getModifiersEx(), false, mouseEvent.getX(), mouseEvent.getY());
        }
    };
    private final GLEventListener glListener = new GLEventListener(){

        public void init(GLAutoDrawable gLAutoDrawable) {
        }

        public void display(GLAutoDrawable gLAutoDrawable) {
        }

        public void dispose(GLAutoDrawable gLAutoDrawable) {
        }

        public void reshape(GLAutoDrawable gLAutoDrawable, int n, int n2, int n3, int n4) {
            ExaminerViewer.this.reshapeMethod(n3, n4);
        }

        public void displayChanged(GLAutoDrawable gLAutoDrawable, boolean bl, boolean bl2) {
        }
    };
    private static final float EPSILON = 1.0E-4f;

    public void attach(AWTGLAutoDrawable aWTGLAutoDrawable, BSphereProvider bSphereProvider) {
        this.window = aWTGLAutoDrawable;
        this.provider = bSphereProvider;
        this.init();
        this.setupListeners();
    }

    public void detach() {
        this.removeListeners();
        this.window = null;
        this.provider = null;
    }

    public void update(GL2 gL2) {
        this.recalc(gL2);
    }

    public void updateInverseRotation(GL2 gL2) {
        this.recalcInverseRotation(gL2);
    }

    public void update() {
        this.recalc();
    }

    public void viewAll(GL2 gL2) {
        float f;
        if (this.provider == null) {
            return;
        }
        float f2 = this.params.getVertFOV() * this.vertFOVScale;
        float f3 = 2.0f * f2;
        float f4 = f3 < (f = 2.0f * (float)Math.atan((double)this.params.getImagePlaneAspectRatio() * Math.tan(f2))) ? f3 : f;
        if (f4 == 0.0f) {
            throw new RuntimeException("Minimum field of view was zero");
        }
        BSphere bSphere = this.provider.getBoundingSphere();
        float f5 = bSphere.getRadius() / (float)Math.sin(f4 / 2.0f);
        this.dolly.setZ(f5);
        this.center.set(bSphere.getCenter());
        this.recalc(gL2);
    }

    public CameraParameters getCameraParameters() {
        return this.params;
    }

    public void rotateFaster() {
        this.rotateSpeed *= 2.0f;
    }

    public void rotateSlower() {
        if (this.rotateSpeed < 1.0E-4f) {
            return;
        }
        this.rotateSpeed /= 2.0f;
    }

    public void dollyFaster() {
        this.dollySpeed *= 2.0f;
    }

    public void dollySlower() {
        if (this.dollySpeed < 1.0E-4f) {
            return;
        }
        this.dollySpeed /= 2.0f;
    }

    public float getZNear() {
        return this.zNear;
    }

    public void setZNear(float f) {
        this.zNear = f;
    }

    public float getZFar() {
        return this.zFar;
    }

    public void setZFar(float f) {
        this.zFar = f;
    }

    public void setVertFOV(float f) {
        this.vertFOVScale = (float)((double)f / 0.7853981633974483);
    }

    public void setPosition(Vec3f vec3f) {
        Vec3f vec3f2 = this.orientation.rotateVector(Vec3f.NEG_Z_AXIS);
        vec3f2.scale(this.dolly.z());
        this.center.add(vec3f, vec3f2);
    }

    public void setOrientation(Rotf rotf) {
        this.orientation.set(rotf);
    }

    public void setUpVector(Vec3f vec3f) {
        this.upVector = vec3f == null ? null : vec3f.copy();
    }

    public void setNoAltKeyMode(boolean bl) {
        this.noAltKeyMode = bl;
    }

    public boolean getNoAltKeyMode() {
        return this.noAltKeyMode;
    }

    public void setAutoRedrawMode(boolean bl) {
        this.autoRedrawMode = bl;
    }

    public boolean getAutoRedrawMode() {
        return this.autoRedrawMode;
    }

    public void rotateAboutFocalPoint(Rotf rotf) {
        this.orientation = rotf.times(this.orientation);
        this.orientation.normalize();
    }

    private void setupListeners() {
        ManipManager.getManipManager().removeMouseListeners(this.window);
        this.window.addMouseMotionListener((MouseMotionListener)this.mouseMotionListener);
        this.window.addMouseListener((MouseListener)this.mouseListener);
        this.window.addGLEventListener(this.glListener);
    }

    private void removeListeners() {
        if (this.window != null) {
            this.window.removeMouseMotionListener((MouseMotionListener)this.mouseMotionListener);
            this.window.removeMouseListener((MouseListener)this.mouseListener);
            this.window.removeGLEventListener(this.glListener);
            ManipManager.getManipManager().setupMouseListeners(this.window);
        }
    }

    private void passiveMotionMethod(MouseEvent mouseEvent) {
        ManipManager.getManipManager().mouseMoved(mouseEvent);
    }

    private boolean modifiersMatch(MouseEvent mouseEvent, int n) {
        if (this.noAltKeyMode) {
            if ((n & 0x400) != 0 && (n & 0x800) == 0 && (n & 0x1000) == 0) {
                return !mouseEvent.isAltDown() && !mouseEvent.isMetaDown() && !mouseEvent.isControlDown() && !mouseEvent.isShiftDown();
            }
            return !mouseEvent.isControlDown() && !mouseEvent.isShiftDown();
        }
        return mouseEvent.isAltDown() || mouseEvent.isMetaDown();
    }

    private void init() {
        this.interactionUnderway = false;
        this.iOwnInteraction = false;
        this.button1Down = false;
        this.button2Down = false;
        int n = this.window.getSurfaceWidth();
        int n2 = this.window.getSurfaceHeight();
        this.params.setOrientation(this.orientation);
        this.params.setPosition(this.computePosition(new Vec3f()));
        this.params.setForwardDirection(Vec3f.NEG_Z_AXIS);
        this.params.setUpDirection(Vec3f.Y_AXIS);
        this.params.setVertFOV(0.3926991f);
        this.params.setImagePlaneAspectRatio((float)n / (float)n2);
        this.params.setXSize(n);
        this.params.setYSize(n2);
    }

    private void motionMethod(MouseEvent mouseEvent, int n, int n2) {
        if (this.interactionUnderway && !this.iOwnInteraction) {
            ManipManager.getManipManager().mouseDragged(mouseEvent);
        } else {
            boolean bl;
            int n3 = n - this.lastX;
            int n4 = n2 - this.lastY;
            this.lastX = n;
            this.lastY = n2;
            boolean bl2 = this.button1Down && !this.button2Down && !this.button3Down;
            boolean bl3 = this.button2Down && !this.button1Down && !this.button3Down;
            boolean bl4 = bl = this.button3Down && !this.button1Down && !this.button2Down;
            if (mouseEvent.isControlDown() && (bl2 || bl || this.button1Down && this.button2Down)) {
                bl2 = false;
                bl = false;
                bl3 = true;
            }
            if (bl2) {
                Vec3f vec3f;
                float f;
                float f2 = (float)(-Math.PI) * (float)n4 * this.rotateSpeed / 1000.0f;
                float f3 = (float)(-Math.PI) * (float)n3 * this.rotateSpeed / 1000.0f;
                Rotf rotf = new Rotf(Vec3f.X_AXIS, f2);
                Rotf rotf2 = new Rotf(Vec3f.Y_AXIS, f3);
                Rotf rotf3 = rotf2.times(rotf);
                this.orientation = this.orientation.times(rotf3);
                if (this.upVector != null && Math.abs(f = (vec3f = this.orientation.rotateVector(Vec3f.Y_AXIS)).dot(this.upVector)) > 1.0E-4f) {
                    Vec3f vec3f2 = this.orientation.rotateVector(Vec3f.Z_AXIS);
                    Vec3f vec3f3 = this.upVector.cross(vec3f2);
                    vec3f3.normalize();
                    vec3f.cross(vec3f2, vec3f3);
                    Mat4f mat4f = new Mat4f();
                    mat4f.setRotation(vec3f3, vec3f, vec3f2);
                    this.orientation.fromMatrix(mat4f);
                }
            } else if (bl3) {
                Vec3f vec3f = new Vec3f(this.dollySpeed * -1.0f * (float)n3 / 100.0f, this.dollySpeed * (float)n4 / 100.0f, 0.0f);
                Vec3f vec3f4 = this.orientation.rotateVector(vec3f);
                this.center.add(vec3f4);
            } else if (bl) {
                float f = this.dollySpeed * (-1.0f * (float)n4 - (float)n3) / 100.0f;
                float f4 = this.dolly.z() + f;
                if (f4 < 1.0f) {
                    f4 = 1.0f;
                }
                this.dolly.setZ(f4);
            }
            if (this.autoRedrawMode) {
                this.window.repaint();
            }
        }
    }

    private void mouseMethod(MouseEvent mouseEvent, int n, boolean bl, int n2, int n3) {
        if (this.interactionUnderway && !this.iOwnInteraction || !this.modifiersMatch(mouseEvent, n)) {
            if (bl) {
                this.interactionUnderway = true;
                this.iOwnInteraction = false;
                ManipManager.getManipManager().mousePressed(mouseEvent);
            } else {
                this.interactionUnderway = false;
                this.iOwnInteraction = false;
                ManipManager.getManipManager().mouseReleased(mouseEvent);
            }
        } else {
            this.button1Down = (n & 0x400) != 0;
            this.button2Down = (n & 0x800) != 0;
            this.button3Down = (n & 0x1000) != 0;
            this.lastX = n2;
            this.lastY = n3;
            if (this.button1Down || this.button2Down || this.button3Down) {
                this.interactionUnderway = true;
                this.iOwnInteraction = true;
            } else {
                this.interactionUnderway = false;
                this.iOwnInteraction = false;
            }
            if (this.autoRedrawMode) {
                this.window.repaint();
            }
        }
    }

    private void reshapeMethod(int n, int n2) {
        float f = (float)n / (float)n2;
        float f2 = n >= n2 ? 45.0f : (float)Math.toDegrees(Math.atan(1.0f / f));
        this.params.setVertFOV((float)(Math.toRadians(f2 *= this.vertFOVScale) / 2.0));
        this.params.setImagePlaneAspectRatio(f);
        this.params.setXSize(n);
        this.params.setYSize(n2);
    }

    private void recalc() {
        Vec3f vec3f = new Vec3f();
        this.params.setPosition(this.computePosition(vec3f));
        this.orientation.rotateVector(Vec3f.NEG_Z_AXIS, vec3f);
        this.params.setForwardDirection(vec3f);
        this.orientation.rotateVector(Vec3f.Y_AXIS, vec3f);
        this.params.setUpDirection(vec3f);
        this.params.setOrientation(this.orientation);
        Mat4f mat4f = new Mat4f();
        mat4f.makeIdent();
        mat4f.setRotation(this.orientation);
        mat4f.setTranslation(this.params.getPosition());
        mat4f.invertRigid();
        this.params.setModelviewMatrix(mat4f);
        float f = this.zFar - this.zNear;
        float f2 = this.params.getImagePlaneAspectRatio();
        float f3 = this.params.getVertFOV();
        float f4 = (float)Math.sin(f3);
        if (f == 0.0f || f4 == 0.0f || f2 == 0.0f) {
            mat4f.makeIdent();
            this.params.setProjectionMatrix(mat4f);
            return;
        }
        float f5 = (float)Math.cos(f3) / f4;
        mat4f.makeIdent();
        mat4f.set(0, 0, f5 / f2);
        mat4f.set(1, 1, f5);
        mat4f.set(2, 2, -(this.zFar + this.zNear) / f);
        mat4f.set(3, 2, -1.0f);
        mat4f.set(2, 3, -2.0f * this.zNear * this.zFar / f);
        mat4f.set(3, 3, 0.0f);
        this.params.setProjectionMatrix(mat4f);
    }

    private void recalc(GL2 gL2) {
        this.recalc();
        gL2.glMatrixMode(5888);
        float[] fArray = new float[16];
        this.params.getModelviewMatrix().getColumnMajorData(fArray);
        gL2.glLoadMatrixf(fArray, 0);
        gL2.glMatrixMode(5889);
        this.params.getProjectionMatrix().getColumnMajorData(fArray);
        gL2.glLoadMatrixf(fArray, 0);
    }

    private void recalcInverseRotation(GL2 gL2) {
        Rotf rotf = this.orientation.inverse();
        Vec3f vec3f = new Vec3f();
        float f = this.orientation.get(vec3f);
        if (vec3f.lengthSquared() > 1.0E-4f) {
            gL2.glRotatef((float)Math.toDegrees(f), vec3f.x(), vec3f.y(), vec3f.z());
        }
    }

    private Vec3f computePosition(Vec3f vec3f) {
        this.orientation.rotateVector(this.dolly, vec3f);
        vec3f.add(this.center);
        return vec3f;
    }
}

