/*
 * Decompiled with CFR 0.152.
 */
package gleem;

import com.jogamp.opengl.GL2;
import gleem.HitPoint;
import gleem.Manip;
import gleem.ManipPart;
import gleem.ManipPartCube;
import gleem.ManipPartGroup;
import gleem.ManipPartLineSeg;
import gleem.ManipPartSquare;
import gleem.ManipPartTransform;
import gleem.ManipPartTwoWayArrow;
import gleem.linalg.IntersectionPoint;
import gleem.linalg.Line;
import gleem.linalg.Mat4f;
import gleem.linalg.MathUtil;
import gleem.linalg.Plane;
import gleem.linalg.PlaneUV;
import gleem.linalg.Rotf;
import gleem.linalg.Vec2f;
import gleem.linalg.Vec3f;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;

public class HandleBoxManip
extends Manip {
    private ManipPart parts = new ManipPartTwoWayArrow();
    private Vec3f translation = new Vec3f(0.0f, 0.0f, 0.0f);
    private Vec3f scale = new Vec3f(1.0f, 1.0f, 1.0f);
    private Vec3f geometryScale = new Vec3f(1.0f, 1.0f, 1.0f);
    private Rotf rotation = new Rotf();
    private Mat4f xform = new Mat4f();
    private static final int INACTIVE = 0;
    private static final int TRANSLATE = 1;
    private static final int ROTATE = 2;
    private static final int SCALE_XYZ = 3;
    private static final int SCALE_SINGLE_AXIS = 4;
    private int dragState = 0;
    private Plane dragPlane = new Plane();
    private Vec3f dragOffset = new Vec3f();
    private static final int SCALE_XY = 0;
    private static final int SCALE_YZ = 1;
    private static final int SCALE_ZX = 2;
    private ManipPart[] lineSegs = new ManipPart[12];
    private List faces = new ArrayList();
    private List highlightedGeometry = new ArrayList();
    private List draggedGeometry = new ArrayList();
    private List rotateHandles = new ArrayList();
    private PlaneUV rotatePlane = new PlaneUV();
    private float startAngle;
    private Rotf startRot = new Rotf();
    private int scaleAxes;
    private List scaleHandles = new ArrayList();
    private Line scaleXYZLine = new Line();
    private float origScaleLen;
    private Vec3f origScale = new Vec3f();
    private PlaneUV scaleAxisPlane = new PlaneUV();
    private Vec3f scaleAxisOffset = new Vec3f();
    private Vec2f scaleAxisOrigUV = new Vec2f();

    public HandleBoxManip() {
        this.createGeometry();
        this.recalc();
    }

    public void setTranslation(Vec3f vec3f) {
        this.translation.set(vec3f);
        this.recalc();
    }

    public Vec3f getTranslation() {
        return new Vec3f(this.translation);
    }

    public void setRotation(Rotf rotf) {
        this.rotation.set(rotf);
        this.recalc();
    }

    public Rotf getRotation() {
        return new Rotf(this.rotation);
    }

    public void setScale(Vec3f vec3f) {
        this.scale.set(vec3f);
        this.recalc();
    }

    public Vec3f getScale() {
        return new Vec3f(this.scale);
    }

    public void setGeometryScale(Vec3f vec3f) {
        this.geometryScale.set(vec3f);
        this.recalc();
    }

    public Vec3f getGeometryScale() {
        return new Vec3f(this.geometryScale);
    }

    public Mat4f getTransform() {
        Mat4f mat4f = new Mat4f();
        this.getTransform(mat4f);
        return mat4f;
    }

    public void getTransform(Mat4f mat4f) {
        Mat4f mat4f2 = new Mat4f();
        Mat4f mat4f3 = new Mat4f();
        mat4f2.makeIdent();
        mat4f3.makeIdent();
        mat4f2.setScale(this.scale);
        mat4f.makeIdent();
        mat4f.setRotation(this.rotation);
        mat4f3.mul(mat4f, mat4f2);
        mat4f2.makeIdent();
        mat4f2.setTranslation(this.translation);
        mat4f.mul(mat4f2, mat4f3);
    }

    @Override
    public void render(GL2 gL2) {
        int n;
        for (n = 0; n < 12; ++n) {
            this.lineSegs[n].render(gL2);
        }
        for (n = 0; n < this.rotateHandles.size(); ++n) {
            ((RotateHandleInfo)this.rotateHandles.get((int)n)).geometry.render(gL2);
        }
        for (n = 0; n < this.scaleHandles.size(); ++n) {
            ((ScaleHandleInfo)this.scaleHandles.get((int)n)).geometry.render(gL2);
        }
    }

    @Override
    public void intersectRay(Vec3f vec3f, Vec3f vec3f2, List list) {
        Iterator iterator = this.faces.iterator();
        while (iterator.hasNext()) {
            ((FaceInfo)iterator.next()).centerSquare.intersectRay(vec3f, vec3f2, list, this);
        }
        iterator = this.rotateHandles.iterator();
        while (iterator.hasNext()) {
            ((RotateHandleInfo)iterator.next()).geometry.intersectRay(vec3f, vec3f2, list, this);
        }
        iterator = this.scaleHandles.iterator();
        while (iterator.hasNext()) {
            ((ScaleHandleInfo)iterator.next()).geometry.intersectRay(vec3f, vec3f2, list, this);
        }
    }

    @Override
    public void highlight(HitPoint hitPoint) {
        ManipPart manipPart = hitPoint.manipPart;
        for (FaceInfo faceInfo : this.faces) {
            if (faceInfo.centerSquare != manipPart) continue;
            for (int i = 0; i < 4; ++i) {
                faceInfo.lineSegs[i].highlight();
                this.highlightedGeometry.add(faceInfo.lineSegs[i]);
            }
            return;
        }
        manipPart.highlight();
        this.highlightedGeometry.add(manipPart);
    }

    @Override
    public void clearHighlight() {
        Iterator iterator = this.highlightedGeometry.iterator();
        while (iterator.hasNext()) {
            ((ManipPart)iterator.next()).clearHighlight();
        }
        this.highlightedGeometry.clear();
    }

    @Override
    public void makeActive(HitPoint hitPoint) {
        for (Object object : this.faces) {
            if (((FaceInfo)object).centerSquare != hitPoint.manipPart) continue;
            this.dragState = 1;
            this.dragPlane.setPoint(hitPoint.intPt.getIntersectionPoint());
            this.dragPlane.setNormal(((FaceInfo)object).normal);
            this.dragOffset.sub(this.translation, hitPoint.intPt.getIntersectionPoint());
            for (int i = 0; i < 4; ++i) {
                ((FaceInfo)object).lineSegs[i].highlight();
                this.draggedGeometry.add(((FaceInfo)object).lineSegs[i]);
            }
            return;
        }
        for (Object object : this.rotateHandles) {
            float f;
            if (((RotateHandleInfo)object).geometry != hitPoint.manipPart) continue;
            this.dragState = 2;
            float f2 = Math.abs(hitPoint.rayDirection.dot(((FaceInfo)this.faces.get((int)((RotateHandleInfo)object).faceIdx0)).normal));
            int n = f2 > (f = Math.abs(hitPoint.rayDirection.dot(((FaceInfo)this.faces.get((int)((RotateHandleInfo)object).faceIdx1)).normal))) ? ((RotateHandleInfo)object).faceIdx0 : ((RotateHandleInfo)object).faceIdx1;
            FaceInfo faceInfo = (FaceInfo)this.faces.get(n);
            this.rotatePlane.setOrigin(this.translation);
            this.rotatePlane.setNormal(faceInfo.normal);
            Vec3f vec3f = new Vec3f();
            Vec2f vec2f = new Vec2f();
            this.rotatePlane.projectPoint(hitPoint.intPt.getIntersectionPoint(), vec3f, vec2f);
            this.startAngle = (float)Math.atan2(vec2f.y(), vec2f.x());
            this.startRot.set(this.rotation);
            ((RotateHandleInfo)object).geometry.highlight();
            this.draggedGeometry.add(((RotateHandleInfo)object).geometry);
            return;
        }
        for (Object object : this.scaleHandles) {
            if (((ScaleHandleInfo)object).geometry != hitPoint.manipPart) continue;
            if (hitPoint.shiftDown) {
                Object object2;
                this.dragState = 4;
                float f = 0.0f;
                int n = 0;
                for (int i = 0; i < 3; ++i) {
                    object2 = (FaceInfo)this.faces.get(((ScaleHandleInfo)object).faceIndices[i]);
                    float f3 = ((FaceInfo)object2).normal.dot(hitPoint.rayDirection);
                    if (i != 0 && !(f3 < f)) continue;
                    f = f3;
                    n = ((ScaleHandleInfo)object).faceIndices[i];
                }
                this.scaleAxes = ((FaceInfo)this.faces.get((int)n)).scaleAxes;
                Vec3f vec3f = new Vec3f();
                object2 = new Vec3f();
                if (this.scaleAxes == 0) {
                    vec3f.set(1.0f, 0.0f, 0.0f);
                    ((Vec3f)object2).set(0.0f, 1.0f, 0.0f);
                } else if (this.scaleAxes == 1) {
                    vec3f.set(0.0f, 1.0f, 0.0f);
                    ((Vec3f)object2).set(0.0f, 0.0f, 1.0f);
                } else {
                    vec3f.set(0.0f, 0.0f, 1.0f);
                    ((Vec3f)object2).set(1.0f, 0.0f, 0.0f);
                }
                Vec3f vec3f2 = new Vec3f();
                Vec3f vec3f3 = new Vec3f();
                Mat4f mat4f = new Mat4f();
                mat4f.makeIdent();
                mat4f.setRotation(this.rotation);
                mat4f.xformDir(vec3f, vec3f2);
                mat4f.xformDir((Vec3f)object2, vec3f3);
                Vec3f vec3f4 = new Vec3f();
                vec3f4.cross(vec3f2, vec3f3);
                this.scaleAxisPlane.setNormalAndUV(vec3f4, vec3f2, vec3f3);
                Vec3f vec3f5 = new Vec3f();
                Vec2f vec2f = new Vec2f();
                this.scaleAxisPlane.projectPoint(this.translation, vec3f5, vec2f);
                this.scaleAxisPlane.setOrigin(vec3f5);
                this.scaleAxisOffset.sub(hitPoint.intPt.getIntersectionPoint(), vec3f5);
                Vec3f vec3f6 = new Vec3f();
                this.scaleAxisPlane.projectPoint(hitPoint.intPt.getIntersectionPoint(), vec3f6, this.scaleAxisOrigUV);
                this.scaleAxisPlane.setOrigin(hitPoint.intPt.getIntersectionPoint());
                this.origScale.set(this.scale);
            } else {
                this.dragState = 3;
                this.scaleXYZLine.setPoint(hitPoint.intPt.getIntersectionPoint());
                Vec3f vec3f = new Vec3f();
                vec3f.sub(hitPoint.intPt.getIntersectionPoint(), this.translation);
                this.scaleXYZLine.setDirection(vec3f);
                this.origScale.set(this.scale);
                this.origScaleLen = vec3f.length();
            }
            ((ScaleHandleInfo)object).geometry.highlight();
            this.draggedGeometry.add(((ScaleHandleInfo)object).geometry);
            return;
        }
        throw new RuntimeException("Couldn't find intersected piece of geometry");
    }

    @Override
    public void drag(Vec3f vec3f, Vec3f vec3f2) {
        if (this.dragState == 1) {
            IntersectionPoint intersectionPoint = new IntersectionPoint();
            if (!this.dragPlane.intersectRay(vec3f, vec3f2, intersectionPoint)) {
                return;
            }
            this.translation.add(intersectionPoint.getIntersectionPoint(), this.dragOffset);
            this.recalc();
        } else if (this.dragState == 2) {
            IntersectionPoint intersectionPoint = new IntersectionPoint();
            Vec2f vec2f = new Vec2f();
            if (!this.rotatePlane.intersectRay(vec3f, vec3f2, intersectionPoint, vec2f)) {
                return;
            }
            Rotf rotf = new Rotf();
            rotf.set(this.rotatePlane.getNormal(), (float)Math.atan2(vec2f.y(), vec2f.x()) - this.startAngle);
            this.rotation.mul(rotf, this.startRot);
            this.recalc();
        } else if (this.dragState == 3) {
            Vec3f vec3f3 = new Vec3f();
            boolean bl = this.scaleXYZLine.closestPointToRay(vec3f, vec3f2, vec3f3);
            if (bl) {
                Vec3f vec3f4 = new Vec3f();
                vec3f4.sub(vec3f3, this.translation);
                if (vec3f4.dot(this.scaleXYZLine.getDirection()) < 0.0f) {
                    this.scale.set(0.0f, 0.0f, 0.0f);
                } else {
                    float f = vec3f4.length() / this.origScaleLen;
                    this.scale.set(this.origScale);
                    this.scale.scale(f);
                }
                this.recalc();
            }
        } else if (this.dragState == 4) {
            IntersectionPoint intersectionPoint = new IntersectionPoint();
            Vec2f vec2f = new Vec2f();
            if (this.scaleAxisPlane.intersectRay(vec3f, vec3f2, intersectionPoint, vec2f)) {
                Vec2f vec2f2 = new Vec2f();
                Vec3f vec3f5 = new Vec3f();
                Vec3f vec3f6 = new Vec3f();
                vec3f6.set(intersectionPoint.getIntersectionPoint());
                vec3f6.add(this.scaleAxisOffset);
                this.scaleAxisPlane.projectPoint(vec3f6, vec3f5, vec2f2);
                if (MathUtil.sgn(vec2f2.x()) == MathUtil.sgn(this.scaleAxisOrigUV.x()) && MathUtil.sgn(vec2f2.y()) == MathUtil.sgn(this.scaleAxisOrigUV.y())) {
                    if (vec2f2.x() < 0.0f) {
                        vec2f.setX(vec2f.x() * -1.0f);
                    }
                    if (vec2f2.y() < 0.0f) {
                        vec2f.setY(vec2f.y() * -1.0f);
                    }
                    Vec3f vec3f7 = new Vec3f();
                    if (Math.abs(vec2f.x()) > Math.abs(vec2f.y())) {
                        if (this.scaleAxes == 0) {
                            vec3f7.setX(vec2f.x());
                        } else if (this.scaleAxes == 1) {
                            vec3f7.setY(vec2f.x());
                        } else {
                            vec3f7.setZ(vec2f.x());
                        }
                    } else if (this.scaleAxes == 0) {
                        vec3f7.setY(vec2f.y());
                    } else if (this.scaleAxes == 1) {
                        vec3f7.setZ(vec2f.y());
                    } else {
                        vec3f7.setX(vec2f.y());
                    }
                    vec3f7.setX(vec3f7.x() / this.geometryScale.x());
                    vec3f7.setY(vec3f7.y() / this.geometryScale.y());
                    vec3f7.setZ(vec3f7.z() / this.geometryScale.z());
                    this.scale.add(this.origScale, vec3f7);
                } else if (Math.abs(vec2f.x()) > Math.abs(vec2f.y())) {
                    if (this.scaleAxes == 0) {
                        this.scale.setX(0.0f);
                    } else if (this.scaleAxes == 1) {
                        this.scale.setY(0.0f);
                    } else {
                        this.scale.setZ(0.0f);
                    }
                } else if (this.scaleAxes == 0) {
                    this.scale.setY(0.0f);
                } else if (this.scaleAxes == 1) {
                    this.scale.setZ(0.0f);
                } else {
                    this.scale.setX(0.0f);
                }
                this.recalc();
            }
        } else {
            throw new RuntimeException("HandleBoxManip::drag: ERROR: Unexpected drag state");
        }
        super.drag(vec3f, vec3f2);
    }

    @Override
    public void makeInactive() {
        this.dragState = 0;
        Iterator iterator = this.draggedGeometry.iterator();
        while (iterator.hasNext()) {
            ((ManipPart)iterator.next()).clearHighlight();
        }
        this.draggedGeometry.clear();
    }

    private void createGeometry() {
        ManipPartGroup manipPartGroup = new ManipPartGroup();
        this.lineSegs[0] = this.createLineSeg(new Vec3f(0.0f, 1.0f, 1.0f), new Vec3f(1.0f, 0.0f, 0.0f), new Vec3f(0.0f, 1.0f, 0.0f));
        this.lineSegs[1] = this.createLineSeg(new Vec3f(-1.0f, 1.0f, 0.0f), new Vec3f(0.0f, 0.0f, 1.0f), new Vec3f(0.0f, 1.0f, 0.0f));
        this.lineSegs[2] = this.createLineSeg(new Vec3f(0.0f, 1.0f, -1.0f), new Vec3f(1.0f, 0.0f, 0.0f), new Vec3f(0.0f, 1.0f, 0.0f));
        this.lineSegs[3] = this.createLineSeg(new Vec3f(1.0f, 1.0f, 0.0f), new Vec3f(0.0f, 0.0f, 1.0f), new Vec3f(0.0f, 1.0f, 0.0f));
        this.lineSegs[4] = this.createLineSeg(new Vec3f(-1.0f, 0.0f, 1.0f), new Vec3f(0.0f, -1.0f, 0.0f), new Vec3f(1.0f, 0.0f, 0.0f));
        this.lineSegs[5] = this.createLineSeg(new Vec3f(-1.0f, 0.0f, -1.0f), new Vec3f(0.0f, -1.0f, 0.0f), new Vec3f(1.0f, 0.0f, 0.0f));
        this.lineSegs[6] = this.createLineSeg(new Vec3f(1.0f, 0.0f, -1.0f), new Vec3f(0.0f, -1.0f, 0.0f), new Vec3f(1.0f, 0.0f, 0.0f));
        this.lineSegs[7] = this.createLineSeg(new Vec3f(1.0f, 0.0f, 1.0f), new Vec3f(0.0f, -1.0f, 0.0f), new Vec3f(1.0f, 0.0f, 0.0f));
        this.lineSegs[8] = this.createLineSeg(new Vec3f(0.0f, -1.0f, 1.0f), new Vec3f(1.0f, 0.0f, 0.0f), new Vec3f(0.0f, 1.0f, 0.0f));
        this.lineSegs[9] = this.createLineSeg(new Vec3f(-1.0f, -1.0f, 0.0f), new Vec3f(0.0f, 0.0f, 1.0f), new Vec3f(0.0f, 1.0f, 0.0f));
        this.lineSegs[10] = this.createLineSeg(new Vec3f(0.0f, -1.0f, -1.0f), new Vec3f(1.0f, 0.0f, 0.0f), new Vec3f(0.0f, 1.0f, 0.0f));
        this.lineSegs[11] = this.createLineSeg(new Vec3f(1.0f, -1.0f, 0.0f), new Vec3f(0.0f, 0.0f, 1.0f), new Vec3f(0.0f, 1.0f, 0.0f));
        for (int i = 0; i < 12; ++i) {
            manipPartGroup.addChild(this.lineSegs[i]);
        }
        FaceInfo faceInfo = new FaceInfo();
        faceInfo.origNormal.set(0.0f, 0.0f, 1.0f);
        faceInfo.centerSquare = this.createFace(faceInfo.origNormal, faceInfo.origNormal, new Vec3f(0.0f, 1.0f, 0.0f));
        faceInfo.lineSegs[0] = this.lineSegs[0];
        faceInfo.lineSegs[1] = this.lineSegs[4];
        faceInfo.lineSegs[2] = this.lineSegs[7];
        faceInfo.lineSegs[3] = this.lineSegs[8];
        faceInfo.scaleAxes = 0;
        this.faces.add(faceInfo);
        faceInfo = new FaceInfo();
        faceInfo.origNormal.set(1.0f, 0.0f, 0.0f);
        faceInfo.centerSquare = this.createFace(faceInfo.origNormal, faceInfo.origNormal, new Vec3f(0.0f, 1.0f, 0.0f));
        faceInfo.lineSegs[0] = this.lineSegs[3];
        faceInfo.lineSegs[1] = this.lineSegs[6];
        faceInfo.lineSegs[2] = this.lineSegs[7];
        faceInfo.lineSegs[3] = this.lineSegs[11];
        faceInfo.scaleAxes = 1;
        this.faces.add(faceInfo);
        faceInfo = new FaceInfo();
        faceInfo.origNormal.set(0.0f, 0.0f, -1.0f);
        faceInfo.centerSquare = this.createFace(faceInfo.origNormal, faceInfo.origNormal, new Vec3f(0.0f, 1.0f, 0.0f));
        faceInfo.lineSegs[0] = this.lineSegs[2];
        faceInfo.lineSegs[1] = this.lineSegs[5];
        faceInfo.lineSegs[2] = this.lineSegs[6];
        faceInfo.lineSegs[3] = this.lineSegs[10];
        faceInfo.scaleAxes = 0;
        this.faces.add(faceInfo);
        faceInfo = new FaceInfo();
        faceInfo.origNormal.set(-1.0f, 0.0f, 0.0f);
        faceInfo.centerSquare = this.createFace(faceInfo.origNormal, faceInfo.origNormal, new Vec3f(0.0f, 1.0f, 0.0f));
        faceInfo.lineSegs[0] = this.lineSegs[1];
        faceInfo.lineSegs[1] = this.lineSegs[4];
        faceInfo.lineSegs[2] = this.lineSegs[5];
        faceInfo.lineSegs[3] = this.lineSegs[9];
        faceInfo.scaleAxes = 1;
        this.faces.add(faceInfo);
        faceInfo = new FaceInfo();
        faceInfo.origNormal.set(0.0f, 1.0f, 0.0f);
        faceInfo.centerSquare = this.createFace(faceInfo.origNormal, faceInfo.origNormal, new Vec3f(0.0f, 0.0f, -1.0f));
        faceInfo.lineSegs[0] = this.lineSegs[0];
        faceInfo.lineSegs[1] = this.lineSegs[1];
        faceInfo.lineSegs[2] = this.lineSegs[2];
        faceInfo.lineSegs[3] = this.lineSegs[3];
        faceInfo.scaleAxes = 2;
        this.faces.add(faceInfo);
        faceInfo = new FaceInfo();
        faceInfo.origNormal.set(0.0f, -1.0f, 0.0f);
        faceInfo.centerSquare = this.createFace(faceInfo.origNormal, faceInfo.origNormal, new Vec3f(0.0f, 0.0f, 1.0f));
        faceInfo.lineSegs[0] = this.lineSegs[8];
        faceInfo.lineSegs[1] = this.lineSegs[9];
        faceInfo.lineSegs[2] = this.lineSegs[10];
        faceInfo.lineSegs[3] = this.lineSegs[11];
        faceInfo.scaleAxes = 2;
        this.faces.add(faceInfo);
        Object object = this.faces.iterator();
        while (object.hasNext()) {
            manipPartGroup.addChild(((FaceInfo)object.next()).centerSquare);
        }
        object = new RotateHandleInfo();
        ((RotateHandleInfo)object).faceIdx0 = 4;
        ((RotateHandleInfo)object).faceIdx1 = 1;
        ((RotateHandleInfo)object).geometry = this.createRotateHandle(new Vec3f(0.0f, 0.0f, 1.0f));
        this.rotateHandles.add(object);
        object = new RotateHandleInfo();
        ((RotateHandleInfo)object).faceIdx0 = 4;
        ((RotateHandleInfo)object).faceIdx1 = 0;
        ((RotateHandleInfo)object).geometry = this.createRotateHandle(new Vec3f(1.0f, 0.0f, 0.0f));
        this.rotateHandles.add(object);
        object = new RotateHandleInfo();
        ((RotateHandleInfo)object).faceIdx0 = 4;
        ((RotateHandleInfo)object).faceIdx1 = 1;
        ((RotateHandleInfo)object).geometry = this.createRotateHandle(new Vec3f(0.0f, 0.0f, -1.0f));
        this.rotateHandles.add(object);
        object = new RotateHandleInfo();
        ((RotateHandleInfo)object).faceIdx0 = 4;
        ((RotateHandleInfo)object).faceIdx1 = 0;
        ((RotateHandleInfo)object).geometry = this.createRotateHandle(new Vec3f(-1.0f, 0.0f, 0.0f));
        this.rotateHandles.add(object);
        object = new RotateHandleInfo();
        ((RotateHandleInfo)object).faceIdx0 = 0;
        ((RotateHandleInfo)object).faceIdx1 = 1;
        ((RotateHandleInfo)object).geometry = this.createRotateHandle(new Vec3f(0.0f, 1.0f, 0.0f));
        this.rotateHandles.add(object);
        object = new RotateHandleInfo();
        ((RotateHandleInfo)object).faceIdx0 = 0;
        ((RotateHandleInfo)object).faceIdx1 = 1;
        ((RotateHandleInfo)object).geometry = this.createRotateHandle(new Vec3f(0.0f, -1.0f, 0.0f));
        this.rotateHandles.add(object);
        Object object2 = this.rotateHandles.iterator();
        while (object2.hasNext()) {
            manipPartGroup.addChild(((RotateHandleInfo)object2.next()).geometry);
        }
        object2 = new ScaleHandleInfo();
        ((ScaleHandleInfo)object2).geometry = this.createScaleHandle(new Vec3f(1.0f, 1.0f, 1.0f));
        ((ScaleHandleInfo)object2).faceIndices[0] = 0;
        ((ScaleHandleInfo)object2).faceIndices[1] = 1;
        ((ScaleHandleInfo)object2).faceIndices[2] = 4;
        this.scaleHandles.add(object2);
        object2 = new ScaleHandleInfo();
        ((ScaleHandleInfo)object2).geometry = this.createScaleHandle(new Vec3f(1.0f, 1.0f, -1.0f));
        ((ScaleHandleInfo)object2).faceIndices[0] = 1;
        ((ScaleHandleInfo)object2).faceIndices[1] = 2;
        ((ScaleHandleInfo)object2).faceIndices[2] = 4;
        this.scaleHandles.add(object2);
        object2 = new ScaleHandleInfo();
        ((ScaleHandleInfo)object2).geometry = this.createScaleHandle(new Vec3f(1.0f, -1.0f, 1.0f));
        ((ScaleHandleInfo)object2).faceIndices[0] = 0;
        ((ScaleHandleInfo)object2).faceIndices[1] = 1;
        ((ScaleHandleInfo)object2).faceIndices[2] = 5;
        this.scaleHandles.add(object2);
        object2 = new ScaleHandleInfo();
        ((ScaleHandleInfo)object2).geometry = this.createScaleHandle(new Vec3f(1.0f, -1.0f, -1.0f));
        ((ScaleHandleInfo)object2).faceIndices[0] = 1;
        ((ScaleHandleInfo)object2).faceIndices[1] = 2;
        ((ScaleHandleInfo)object2).faceIndices[2] = 5;
        this.scaleHandles.add(object2);
        object2 = new ScaleHandleInfo();
        ((ScaleHandleInfo)object2).geometry = this.createScaleHandle(new Vec3f(-1.0f, 1.0f, 1.0f));
        ((ScaleHandleInfo)object2).faceIndices[0] = 0;
        ((ScaleHandleInfo)object2).faceIndices[1] = 3;
        ((ScaleHandleInfo)object2).faceIndices[2] = 4;
        this.scaleHandles.add(object2);
        object2 = new ScaleHandleInfo();
        ((ScaleHandleInfo)object2).geometry = this.createScaleHandle(new Vec3f(-1.0f, 1.0f, -1.0f));
        ((ScaleHandleInfo)object2).faceIndices[0] = 2;
        ((ScaleHandleInfo)object2).faceIndices[1] = 3;
        ((ScaleHandleInfo)object2).faceIndices[2] = 4;
        this.scaleHandles.add(object2);
        object2 = new ScaleHandleInfo();
        ((ScaleHandleInfo)object2).geometry = this.createScaleHandle(new Vec3f(-1.0f, -1.0f, 1.0f));
        ((ScaleHandleInfo)object2).faceIndices[0] = 0;
        ((ScaleHandleInfo)object2).faceIndices[1] = 3;
        ((ScaleHandleInfo)object2).faceIndices[2] = 5;
        this.scaleHandles.add(object2);
        object2 = new ScaleHandleInfo();
        ((ScaleHandleInfo)object2).geometry = this.createScaleHandle(new Vec3f(-1.0f, -1.0f, -1.0f));
        ((ScaleHandleInfo)object2).faceIndices[0] = 2;
        ((ScaleHandleInfo)object2).faceIndices[1] = 3;
        ((ScaleHandleInfo)object2).faceIndices[2] = 5;
        this.scaleHandles.add(object2);
        Iterator iterator = this.scaleHandles.iterator();
        while (iterator.hasNext()) {
            manipPartGroup.addChild(((ScaleHandleInfo)iterator.next()).geometry);
        }
        this.parts = manipPartGroup;
    }

    private ManipPart createLineSeg(Vec3f vec3f, Vec3f vec3f2, Vec3f vec3f3) {
        ManipPartTransform manipPartTransform = new ManipPartTransform();
        ManipPartLineSeg manipPartLineSeg = new ManipPartLineSeg();
        manipPartTransform.addChild(manipPartLineSeg);
        Mat4f mat4f = new Mat4f();
        mat4f.makeIdent();
        Vec3f vec3f4 = new Vec3f();
        vec3f4.cross(vec3f2, vec3f3);
        mat4f.set(0, 0, vec3f2.x());
        mat4f.set(1, 0, vec3f2.y());
        mat4f.set(2, 0, vec3f2.z());
        mat4f.set(0, 1, vec3f3.x());
        mat4f.set(1, 1, vec3f3.y());
        mat4f.set(2, 1, vec3f3.z());
        mat4f.set(0, 2, vec3f4.x());
        mat4f.set(1, 2, vec3f4.y());
        mat4f.set(2, 2, vec3f4.z());
        mat4f.set(0, 3, vec3f.x());
        mat4f.set(1, 3, vec3f.y());
        mat4f.set(2, 3, vec3f.z());
        manipPartTransform.setOffsetTransform(mat4f);
        return manipPartTransform;
    }

    private ManipPart createFace(Vec3f vec3f, Vec3f vec3f2, Vec3f vec3f3) {
        ManipPartTransform manipPartTransform = new ManipPartTransform();
        ManipPartSquare manipPartSquare = new ManipPartSquare();
        manipPartSquare.setVisible(false);
        manipPartTransform.addChild(manipPartSquare);
        Mat4f mat4f = new Mat4f();
        mat4f.makeIdent();
        Vec3f vec3f4 = new Vec3f();
        vec3f4.cross(vec3f3, vec3f2);
        mat4f.set(0, 0, vec3f4.x());
        mat4f.set(1, 0, vec3f4.y());
        mat4f.set(2, 0, vec3f4.z());
        mat4f.set(0, 1, vec3f3.x());
        mat4f.set(1, 1, vec3f3.y());
        mat4f.set(2, 1, vec3f3.z());
        mat4f.set(0, 2, vec3f2.x());
        mat4f.set(1, 2, vec3f2.y());
        mat4f.set(2, 2, vec3f2.z());
        mat4f.set(0, 3, vec3f.x());
        mat4f.set(1, 3, vec3f.y());
        mat4f.set(2, 3, vec3f.z());
        manipPartTransform.setOffsetTransform(mat4f);
        return manipPartTransform;
    }

    private ManipPart createRotateHandle(Vec3f vec3f) {
        ManipPartCube manipPartCube = new ManipPartCube();
        Mat4f mat4f = new Mat4f();
        mat4f.makeIdent();
        mat4f.set(0, 0, 0.1f);
        mat4f.set(1, 1, 0.1f);
        mat4f.set(2, 2, 0.1f);
        Vec3f vec3f2 = new Vec3f(vec3f);
        vec3f2.scale(2.0f);
        mat4f.setTranslation(vec3f2);
        ManipPartTransform manipPartTransform = new ManipPartTransform();
        manipPartTransform.addChild(manipPartCube);
        manipPartTransform.setOffsetTransform(mat4f);
        return manipPartTransform;
    }

    private ManipPart createScaleHandle(Vec3f vec3f) {
        ManipPartCube manipPartCube = new ManipPartCube();
        Mat4f mat4f = new Mat4f();
        mat4f.makeIdent();
        mat4f.set(0, 0, 0.1f);
        mat4f.set(1, 1, 0.1f);
        mat4f.set(2, 2, 0.1f);
        mat4f.setTranslation(vec3f);
        ManipPartTransform manipPartTransform = new ManipPartTransform();
        manipPartTransform.addChild(manipPartCube);
        manipPartTransform.setOffsetTransform(mat4f);
        return manipPartTransform;
    }

    private void recalc() {
        int n;
        Mat4f mat4f = new Mat4f();
        Mat4f mat4f2 = new Mat4f();
        Mat4f mat4f3 = new Mat4f();
        Mat4f mat4f4 = new Mat4f();
        mat4f.makeIdent();
        mat4f.set(0, 0, this.scale.x() * this.geometryScale.x());
        mat4f.set(1, 1, this.scale.y() * this.geometryScale.y());
        mat4f.set(2, 2, this.scale.z() * this.geometryScale.z());
        mat4f2.makeIdent();
        mat4f2.setRotation(this.rotation);
        mat4f3.makeIdent();
        mat4f3.set(0, 3, this.translation.x());
        mat4f3.set(1, 3, this.translation.y());
        mat4f3.set(2, 3, this.translation.z());
        mat4f4.mul(mat4f3, mat4f2);
        this.xform.mul(mat4f4, mat4f);
        for (n = 0; n < 12; ++n) {
            this.lineSegs[n].setTransform(this.xform);
        }
        for (n = 0; n < this.faces.size(); ++n) {
            FaceInfo faceInfo = (FaceInfo)this.faces.get(n);
            faceInfo.centerSquare.setTransform(this.xform);
            this.xform.xformDir(faceInfo.origNormal, faceInfo.normal);
            faceInfo.normal.normalize();
            RotateHandleInfo rotateHandleInfo = (RotateHandleInfo)this.rotateHandles.get(n);
            rotateHandleInfo.geometry.setTransform(this.xform);
        }
        for (n = 0; n < this.scaleHandles.size(); ++n) {
            ((ScaleHandleInfo)this.scaleHandles.get((int)n)).geometry.setTransform(this.xform);
        }
    }

    static class RotateHandleInfo {
        ManipPart geometry;
        int faceIdx0;
        int faceIdx1;

        RotateHandleInfo() {
        }
    }

    static class ScaleHandleInfo {
        ManipPart geometry;
        int[] faceIndices = new int[3];

        ScaleHandleInfo() {
        }
    }

    static class FaceInfo {
        ManipPart[] lineSegs = new ManipPart[4];
        ManipPart centerSquare;
        Vec3f origNormal = new Vec3f();
        Vec3f normal = new Vec3f();
        int scaleAxes;

        FaceInfo() {
        }
    }
}

