/*
 * Decompiled with CFR 0.152.
 */
package gleem;

import com.jogamp.opengl.GL2;
import gleem.Manip;
import gleem.ManipPart;
import gleem.linalg.Mat4f;
import gleem.linalg.Vec3f;
import java.util.List;

public class ManipPartLineSeg
extends ManipPart {
    private Vec3f color = new Vec3f(0.8f, 0.8f, 0.8f);
    private Vec3f highlightColor = new Vec3f(0.8f, 0.8f, 0.2f);
    private boolean highlighted = false;
    private boolean visible = true;
    private static Vec3f[] vertices = new Vec3f[]{new Vec3f(-1.0f, 0.0f, 0.0f), new Vec3f(1.0f, 0.0f, 0.0f)};
    private Mat4f xform = new Mat4f();
    private Vec3f[] curVertices;

    public ManipPartLineSeg() {
        this.xform.makeIdent();
        this.curVertices = null;
    }

    public void setColor(Vec3f vec3f) {
        this.color.set(vec3f);
    }

    public Vec3f getColor() {
        return new Vec3f(this.color);
    }

    public void setHighlightColor(Vec3f vec3f) {
        this.highlightColor.set(vec3f);
    }

    public Vec3f getHighlightColor() {
        return new Vec3f(this.highlightColor);
    }

    @Override
    public void intersectRay(Vec3f vec3f, Vec3f vec3f2, List list, Manip manip) {
    }

    @Override
    public void setTransform(Mat4f mat4f) {
        this.xform.set(mat4f);
        this.recalcVertices();
    }

    @Override
    public void highlight() {
        this.highlighted = true;
    }

    @Override
    public void clearHighlight() {
        this.highlighted = false;
    }

    @Override
    public void setPickable(boolean bl) {
    }

    @Override
    public boolean getPickable() {
        return false;
    }

    @Override
    public void setVisible(boolean bl) {
        this.visible = bl;
    }

    @Override
    public boolean getVisible() {
        return this.visible;
    }

    @Override
    public void render(GL2 gL2) {
        if (!this.visible) {
            return;
        }
        boolean bl = gL2.glIsEnabled(2896);
        gL2.glDisable(2896);
        gL2.glBegin(1);
        if (this.highlighted) {
            gL2.glColor3f(this.highlightColor.x(), this.highlightColor.y(), this.highlightColor.z());
        } else {
            gL2.glColor3f(this.color.x(), this.color.y(), this.color.z());
        }
        for (int i = 0; i < this.curVertices.length; ++i) {
            Vec3f vec3f = this.curVertices[i];
            gL2.glVertex3f(vec3f.x(), vec3f.y(), vec3f.z());
        }
        gL2.glEnd();
        if (bl) {
            gL2.glEnable(2896);
        }
    }

    private void recalcVertices() {
        int n;
        if (this.curVertices == null || this.curVertices.length != vertices.length) {
            this.curVertices = new Vec3f[vertices.length];
            for (n = 0; n < vertices.length; ++n) {
                this.curVertices[n] = new Vec3f();
            }
        }
        for (n = 0; n < this.curVertices.length; ++n) {
            this.xform.xformPt(vertices[n], this.curVertices[n]);
        }
    }
}

