/*
 * Decompiled with CFR 0.152.
 */
package gleem;

import gleem.linalg.Vec3f;

public class NormalCalc {
    public static NormalInfo computeFacetedNormals(Vec3f[] vec3fArray, int[] nArray, boolean bl) {
        if (nArray.length % 3 != 0) {
            System.err.println("NormalCalc.computeFacetedNormals: numIndices wasn't divisible by 3, so it can't possibly represent a set of triangles");
            return null;
        }
        Vec3f[] vec3fArray2 = new Vec3f[nArray.length / 3];
        int[] nArray2 = new int[nArray.length];
        Vec3f vec3f = new Vec3f();
        Vec3f vec3f2 = new Vec3f();
        int n = 0;
        for (int i = 0; i < nArray.length; i += 3) {
            int n2 = nArray[i];
            int n3 = nArray[i + 1];
            int n4 = nArray[i + 2];
            if (n2 < 0 || n2 >= nArray.length || n3 < 0 || n3 >= nArray.length || n4 < 0 || n4 >= nArray.length) {
                System.err.println("NormalCalc.computeFacetedNormals: ERROR: vertex index out of bounds or no end of triangle index found");
                return null;
            }
            Vec3f vec3f3 = vec3fArray[n2];
            Vec3f vec3f4 = vec3fArray[n3];
            Vec3f vec3f5 = vec3fArray[n4];
            vec3f.sub(vec3f4, vec3f3);
            vec3f2.sub(vec3f5, vec3f3);
            Vec3f vec3f6 = new Vec3f();
            if (bl) {
                vec3f6.cross(vec3f, vec3f2);
            } else {
                vec3f6.cross(vec3f2, vec3f);
            }
            vec3f6.normalize();
            vec3fArray2[n] = vec3f6;
            nArray2[i] = n;
            nArray2[i + 1] = n;
            nArray2[i + 2] = n++;
        }
        return new NormalInfo(vec3fArray2, nArray2);
    }

    public static class NormalInfo {
        public Vec3f[] normals;
        public int[] normalIndices;

        NormalInfo(Vec3f[] vec3fArray, int[] nArray) {
            this.normals = vec3fArray;
            this.normalIndices = nArray;
        }
    }
}

