/*
 * Decompiled with CFR 0.152.
 */
package gleem;

import com.jogamp.opengl.GL2;
import com.jogamp.opengl.GLAutoDrawable;
import com.jogamp.opengl.GLEventListener;
import com.jogamp.opengl.awt.AWTGLAutoDrawable;
import com.jogamp.opengl.awt.GLCanvas;
import com.jogamp.opengl.glu.GLU;
import gleem.BSphere;
import gleem.BSphereProvider;
import gleem.CameraParameters;
import gleem.ExaminerViewer;
import gleem.HandleBoxManip;
import gleem.ManipManager;
import gleem.linalg.Vec3f;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Frame;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;

public class TestExaminerViewer {
    private static final int X_SIZE = 400;
    private static final int Y_SIZE = 400;

    public static void main(String[] stringArray) {
        Frame frame = new Frame("ExaminerViewer Test");
        frame.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent windowEvent) {
                System.exit(0);
            }
        });
        frame.setLayout(new BorderLayout());
        GLCanvas gLCanvas = new GLCanvas();
        gLCanvas.setSize(400, 400);
        gLCanvas.addGLEventListener((GLEventListener)new Listener());
        frame.add((Component)gLCanvas, "Center");
        frame.pack();
        frame.setVisible(true);
    }

    static class Listener
    implements GLEventListener {
        private GLU glu = new GLU();
        private CameraParameters params = new CameraParameters();
        private ExaminerViewer viewer;

        Listener() {
        }

        public void init(GLAutoDrawable gLAutoDrawable) {
            GL2 gL2 = gLAutoDrawable.getGL().getGL2();
            gL2.glClearColor(0.0f, 0.0f, 0.0f, 0.0f);
            float[] fArray = new float[]{1.0f, 1.0f, 1.0f, 0.0f};
            float[] fArray2 = new float[]{0.0f, 0.0f, 0.0f, 1.0f};
            float[] fArray3 = new float[]{1.0f, 1.0f, 1.0f, 1.0f};
            gL2.glLightfv(16384, 4608, fArray2, 0);
            gL2.glLightfv(16384, 4609, fArray3, 0);
            gL2.glLightfv(16384, 4611, fArray, 0);
            gL2.glEnable(2896);
            gL2.glEnable(16384);
            gL2.glEnable(2929);
            this.params.setPosition(new Vec3f(0.0f, 0.0f, 0.0f));
            this.params.setForwardDirection(Vec3f.NEG_Z_AXIS);
            this.params.setUpDirection(Vec3f.Y_AXIS);
            this.params.setVertFOV(0.3926991f);
            this.params.setImagePlaneAspectRatio(1.0f);
            this.params.xSize = 400;
            this.params.ySize = 400;
            gL2.glMatrixMode(5889);
            gL2.glLoadIdentity();
            this.glu.gluPerspective(45.0f, 1.0f, 1.0f, 100.0f);
            gL2.glMatrixMode(5888);
            gL2.glLoadIdentity();
            ManipManager manipManager = ManipManager.getManipManager();
            manipManager.registerWindow((AWTGLAutoDrawable)gLAutoDrawable);
            HandleBoxManip handleBoxManip = new HandleBoxManip();
            handleBoxManip.setTranslation(new Vec3f(0.0f, 0.0f, -10.0f));
            manipManager.showManipInWindow(handleBoxManip, (AWTGLAutoDrawable)gLAutoDrawable);
            this.viewer = new ExaminerViewer();
            this.viewer.setUpVector(Vec3f.Y_AXIS);
            this.viewer.attach((AWTGLAutoDrawable)gLAutoDrawable, new HandleBoxManipBSphereProvider(handleBoxManip));
            this.viewer.viewAll(gL2);
        }

        public void dispose(GLAutoDrawable gLAutoDrawable) {
        }

        public void display(GLAutoDrawable gLAutoDrawable) {
            GL2 gL2 = gLAutoDrawable.getGL().getGL2();
            gL2.glClear(16640);
            this.viewer.update(gL2);
            ManipManager.getManipManager().updateCameraParameters((AWTGLAutoDrawable)gLAutoDrawable, this.viewer.getCameraParameters());
            ManipManager.getManipManager().render((AWTGLAutoDrawable)gLAutoDrawable, gL2);
        }

        public void reshape(GLAutoDrawable gLAutoDrawable, int n, int n2, int n3, int n4) {
        }

        public void displayChanged(GLAutoDrawable gLAutoDrawable, boolean bl, boolean bl2) {
        }
    }

    static class HandleBoxManipBSphereProvider
    implements BSphereProvider {
        private HandleBoxManip manip;

        private HandleBoxManipBSphereProvider(HandleBoxManip handleBoxManip) {
            this.manip = handleBoxManip;
        }

        @Override
        public BSphere getBoundingSphere() {
            BSphere bSphere = new BSphere();
            bSphere.setCenter(this.manip.getTranslation());
            Vec3f vec3f = this.manip.getScale();
            Vec3f vec3f2 = this.manip.getGeometryScale();
            Vec3f vec3f3 = new Vec3f();
            vec3f3.setX(2.0f * vec3f.x() * vec3f2.x());
            vec3f3.setY(2.0f * vec3f.y() * vec3f2.y());
            vec3f3.setZ(2.0f * vec3f.z() * vec3f2.z());
            bSphere.setRadius(vec3f3.length());
            return bSphere;
        }
    }
}

