/*
 * Decompiled with CFR 0.152.
 */
package gleem;

import com.jogamp.opengl.GL2;
import gleem.HitPoint;
import gleem.Manip;
import gleem.ManipPart;
import gleem.ManipPartGroup;
import gleem.ManipPartTransform;
import gleem.ManipPartTwoWayArrow;
import gleem.linalg.IntersectionPoint;
import gleem.linalg.Mat4f;
import gleem.linalg.MathUtil;
import gleem.linalg.Plane;
import gleem.linalg.Vec3f;
import java.util.List;

public class Translate2Manip
extends Manip {
    private ManipPart parts = this.createGeometry();
    private Vec3f translation = new Vec3f(0.0f, 0.0f, 0.0f);
    private Vec3f normal = new Vec3f(0.0f, 1.0f, 0.0f);
    private Vec3f scale = new Vec3f(1.0f, 1.0f, 1.0f);
    private Mat4f xform = new Mat4f();
    private Plane dragPlane = new Plane();
    private Vec3f dragOffset = new Vec3f();

    public Translate2Manip() {
        this.recalc();
    }

    public void setTranslation(Vec3f vec3f) {
        this.translation.set(vec3f);
        this.recalc();
    }

    public Vec3f getTranslation() {
        return new Vec3f(this.translation);
    }

    public void setNormal(Vec3f vec3f) {
        this.normal.set(vec3f);
        this.normal.normalize();
        this.recalc();
    }

    public Vec3f getNormal() {
        return new Vec3f(this.normal);
    }

    public void setScale(Vec3f vec3f) {
        this.scale.set(vec3f);
        this.recalc();
    }

    public Vec3f getScale() {
        return new Vec3f(this.scale);
    }

    public void replaceGeometry(ManipPart manipPart) {
        this.parts = manipPart;
    }

    @Override
    public void intersectRay(Vec3f vec3f, Vec3f vec3f2, List list) {
        this.parts.intersectRay(vec3f, vec3f2, list, this);
    }

    @Override
    public void highlight(HitPoint hitPoint) {
        if (hitPoint.manipPart != this.parts) {
            throw new RuntimeException("My old geometry disappeared; how did this happen?");
        }
        this.parts.highlight();
    }

    @Override
    public void clearHighlight() {
        this.parts.clearHighlight();
    }

    @Override
    public void makeActive(HitPoint hitPoint) {
        this.parts.highlight();
        this.dragPlane.setNormal(this.normal);
        this.dragPlane.setPoint(hitPoint.intPt.getIntersectionPoint());
        this.dragOffset.sub(this.translation, hitPoint.intPt.getIntersectionPoint());
    }

    @Override
    public void drag(Vec3f vec3f, Vec3f vec3f2) {
        IntersectionPoint intersectionPoint = new IntersectionPoint();
        if (!this.dragPlane.intersectRay(vec3f, vec3f2, intersectionPoint)) {
            return;
        }
        this.translation.set(intersectionPoint.getIntersectionPoint());
        this.translation.add(this.dragOffset);
        this.recalc();
        super.drag(vec3f, vec3f2);
    }

    @Override
    public void makeInactive() {
        this.parts.clearHighlight();
    }

    @Override
    public void render(GL2 gL2) {
        this.parts.render(gL2);
    }

    private ManipPart createGeometry() {
        ManipPartGroup manipPartGroup = new ManipPartGroup();
        ManipPartTwoWayArrow manipPartTwoWayArrow = new ManipPartTwoWayArrow();
        manipPartGroup.addChild(manipPartTwoWayArrow);
        ManipPartTransform manipPartTransform = new ManipPartTransform();
        Mat4f mat4f = new Mat4f();
        mat4f.makeIdent();
        mat4f.set(0, 0, 0.0f);
        mat4f.set(1, 0, 0.0f);
        mat4f.set(2, 0, -1.0f);
        mat4f.set(0, 2, 1.0f);
        mat4f.set(1, 2, 0.0f);
        mat4f.set(2, 2, 0.0f);
        manipPartTransform.setOffsetTransform(mat4f);
        ManipPartTwoWayArrow manipPartTwoWayArrow2 = new ManipPartTwoWayArrow();
        manipPartTransform.addChild(manipPartTwoWayArrow2);
        manipPartGroup.addChild(manipPartTransform);
        return manipPartGroup;
    }

    private void recalc() {
        Mat4f mat4f = new Mat4f();
        Mat4f mat4f2 = new Mat4f();
        Mat4f mat4f3 = new Mat4f();
        Mat4f mat4f4 = new Mat4f();
        mat4f.makeIdent();
        mat4f.set(0, 0, this.scale.x());
        mat4f.set(1, 1, this.scale.y());
        mat4f.set(2, 2, this.scale.z());
        Vec3f vec3f = new Vec3f();
        Vec3f vec3f2 = new Vec3f();
        MathUtil.makePerpendicular(this.normal, vec3f);
        vec3f2.cross(this.normal, vec3f);
        vec3f.normalize();
        vec3f2.normalize();
        mat4f2.makeIdent();
        mat4f2.set(0, 0, vec3f2.x());
        mat4f2.set(1, 0, vec3f2.y());
        mat4f2.set(2, 0, vec3f2.z());
        mat4f2.set(0, 1, this.normal.x());
        mat4f2.set(1, 1, this.normal.y());
        mat4f2.set(2, 1, this.normal.z());
        mat4f2.set(0, 2, vec3f.x());
        mat4f2.set(1, 2, vec3f.y());
        mat4f2.set(2, 2, vec3f.z());
        mat4f3.makeIdent();
        mat4f3.set(0, 3, this.translation.x());
        mat4f3.set(1, 3, this.translation.y());
        mat4f3.set(2, 3, this.translation.z());
        mat4f4.mul(mat4f3, mat4f2);
        this.xform.mul(mat4f4, mat4f);
        this.parts.setTransform(this.xform);
    }
}

