/*
 * Decompiled with CFR 0.152.
 */
package gleem.linalg;

import gleem.linalg.Matf;
import gleem.linalg.Vec2f;

public class Mat2f {
    private float[] data = new float[4];

    public void makeIdent() {
        for (int i = 0; i < 2; ++i) {
            for (int j = 0; j < 2; ++j) {
                if (i == j) {
                    this.set(i, j, 1.0f);
                    continue;
                }
                this.set(i, j, 0.0f);
            }
        }
    }

    public float get(int n, int n2) {
        return this.data[2 * n + n2];
    }

    public void set(int n, int n2, float f) {
        this.data[2 * n + n2] = f;
    }

    public void setCol(int n, Vec2f vec2f) {
        this.set(0, n, vec2f.x());
        this.set(1, n, vec2f.y());
    }

    public void setRow(int n, Vec2f vec2f) {
        this.set(n, 0, vec2f.x());
        this.set(n, 1, vec2f.y());
    }

    public void transpose() {
        float f = this.get(0, 1);
        this.set(0, 1, this.get(1, 0));
        this.set(1, 0, f);
    }

    public float determinant() {
        return this.get(0, 0) * this.get(1, 1) - this.get(1, 0) * this.get(0, 1);
    }

    public boolean invert() {
        float f = this.determinant();
        if (f == 0.0f) {
            return false;
        }
        float f2 = this.get(0, 0);
        this.set(0, 0, this.get(1, 1));
        this.set(1, 1, f2);
        this.set(0, 1, -this.get(0, 1));
        this.set(1, 0, -this.get(1, 0));
        int n = 0;
        while (n < 4) {
            int n2 = n++;
            this.data[n2] = this.data[n2] / f;
        }
        return true;
    }

    public void xformVec(Vec2f vec2f, Vec2f vec2f2) {
        vec2f2.set(this.get(0, 0) * vec2f.x() + this.get(0, 1) * vec2f.y(), this.get(1, 0) * vec2f.x() + this.get(1, 1) * vec2f.y());
    }

    public Mat2f mul(Mat2f mat2f) {
        Mat2f mat2f2 = new Mat2f();
        mat2f2.mul(this, mat2f);
        return mat2f2;
    }

    public void mul(Mat2f mat2f, Mat2f mat2f2) {
        for (int i = 0; i < 2; ++i) {
            for (int j = 0; j < 2; ++j) {
                float f = 0.0f;
                for (int k = 0; k < 2; ++k) {
                    f += mat2f.get(i, k) * mat2f2.get(k, j);
                }
                this.set(i, j, f);
            }
        }
    }

    public Matf toMatf() {
        Matf matf = new Matf(2, 2);
        for (int i = 0; i < 2; ++i) {
            for (int j = 0; j < 2; ++j) {
                matf.set(i, j, this.get(i, j));
            }
        }
        return matf;
    }

    public String toString() {
        String string = System.getProperty("line.separator");
        return "(" + this.get(0, 0) + ", " + this.get(0, 1) + string + this.get(1, 0) + ", " + this.get(1, 1) + ")";
    }
}

