/*
 * Decompiled with CFR 0.152.
 */
package gleem.linalg;

import gleem.linalg.Matf;
import gleem.linalg.Vec3f;

public class Mat3f {
    private float[] data = new float[9];

    public void makeIdent() {
        for (int i = 0; i < 3; ++i) {
            for (int j = 0; j < 3; ++j) {
                if (i == j) {
                    this.set(i, j, 1.0f);
                    continue;
                }
                this.set(i, j, 0.0f);
            }
        }
    }

    public float get(int n, int n2) {
        return this.data[3 * n + n2];
    }

    public void set(int n, int n2, float f) {
        this.data[3 * n + n2] = f;
    }

    public void setCol(int n, Vec3f vec3f) {
        this.set(0, n, vec3f.x());
        this.set(1, n, vec3f.y());
        this.set(2, n, vec3f.z());
    }

    public void setRow(int n, Vec3f vec3f) {
        this.set(n, 0, vec3f.x());
        this.set(n, 1, vec3f.y());
        this.set(n, 2, vec3f.z());
    }

    public void transpose() {
        float f = this.get(0, 1);
        this.set(0, 1, this.get(1, 0));
        this.set(1, 0, f);
        f = this.get(0, 2);
        this.set(0, 2, this.get(2, 0));
        this.set(2, 0, f);
        f = this.get(1, 2);
        this.set(1, 2, this.get(2, 1));
        this.set(2, 1, f);
    }

    public float determinant() {
        return this.get(0, 0) * (this.get(1, 1) * this.get(2, 2) - this.get(2, 1) * this.get(1, 2)) + this.get(0, 1) * (this.get(2, 0) * this.get(1, 2) - this.get(1, 0) * this.get(2, 2)) + this.get(0, 2) * (this.get(1, 0) * this.get(2, 1) - this.get(2, 0) * this.get(1, 1));
    }

    public boolean invert() {
        float f = this.determinant();
        if (f == 0.0f) {
            return false;
        }
        Mat3f mat3f = new Mat3f();
        mat3f.set(0, 0, this.get(1, 1) * this.get(2, 2) - this.get(2, 1) * this.get(1, 2));
        mat3f.set(0, 1, this.get(2, 0) * this.get(1, 2) - this.get(1, 0) * this.get(2, 2));
        mat3f.set(0, 2, this.get(1, 0) * this.get(2, 1) - this.get(2, 0) * this.get(1, 1));
        mat3f.set(1, 0, this.get(2, 1) * this.get(0, 2) - this.get(0, 1) * this.get(2, 2));
        mat3f.set(1, 1, this.get(0, 0) * this.get(2, 2) - this.get(2, 0) * this.get(0, 2));
        mat3f.set(1, 2, this.get(2, 0) * this.get(0, 1) - this.get(0, 0) * this.get(2, 1));
        mat3f.set(2, 0, this.get(0, 1) * this.get(1, 2) - this.get(1, 1) * this.get(0, 2));
        mat3f.set(2, 1, this.get(1, 0) * this.get(0, 2) - this.get(0, 0) * this.get(1, 2));
        mat3f.set(2, 2, this.get(0, 0) * this.get(1, 1) - this.get(1, 0) * this.get(0, 1));
        for (int i = 0; i < 3; ++i) {
            for (int j = 0; j < 3; ++j) {
                this.set(i, j, mat3f.get(j, i) / f);
            }
        }
        return true;
    }

    public void xformVec(Vec3f vec3f, Vec3f vec3f2) {
        vec3f2.set(this.get(0, 0) * vec3f.x() + this.get(0, 1) * vec3f.y() + this.get(0, 2) * vec3f.z(), this.get(1, 0) * vec3f.x() + this.get(1, 1) * vec3f.y() + this.get(1, 2) * vec3f.z(), this.get(2, 0) * vec3f.x() + this.get(2, 1) * vec3f.y() + this.get(2, 2) * vec3f.z());
    }

    public Mat3f mul(Mat3f mat3f) {
        Mat3f mat3f2 = new Mat3f();
        mat3f2.mul(this, mat3f);
        return mat3f2;
    }

    public void mul(Mat3f mat3f, Mat3f mat3f2) {
        for (int i = 0; i < 3; ++i) {
            for (int j = 0; j < 3; ++j) {
                float f = 0.0f;
                for (int k = 0; k < 3; ++k) {
                    f += mat3f.get(i, k) * mat3f2.get(k, j);
                }
                this.set(i, j, f);
            }
        }
    }

    public Matf toMatf() {
        Matf matf = new Matf(3, 3);
        for (int i = 0; i < 3; ++i) {
            for (int j = 0; j < 3; ++j) {
                matf.set(i, j, this.get(i, j));
            }
        }
        return matf;
    }

    public String toString() {
        String string = System.getProperty("line.separator");
        return "(" + this.get(0, 0) + ", " + this.get(0, 1) + ", " + this.get(0, 2) + string + this.get(1, 0) + ", " + this.get(1, 1) + ", " + this.get(1, 2) + string + this.get(2, 0) + ", " + this.get(2, 1) + ", " + this.get(2, 2) + ")";
    }
}

