/*
 * Decompiled with CFR 0.152.
 */
package gleem.linalg;

import gleem.linalg.Matf;
import gleem.linalg.Rotf;
import gleem.linalg.Vec3f;
import gleem.linalg.Vec4f;

public class Mat4f {
    private float[] data = new float[16];

    public Mat4f() {
    }

    public Mat4f(Mat4f mat4f) {
        this();
        this.set(mat4f);
    }

    public void makeIdent() {
        for (int i = 0; i < 4; ++i) {
            for (int j = 0; j < 4; ++j) {
                if (i == j) {
                    this.set(i, j, 1.0f);
                    continue;
                }
                this.set(i, j, 0.0f);
            }
        }
    }

    public void set(Mat4f mat4f) {
        float[] fArray = this.data;
        float[] fArray2 = mat4f.data;
        for (int i = 0; i < fArray.length; ++i) {
            fArray[i] = fArray2[i];
        }
    }

    public float get(int n, int n2) {
        return this.data[4 * n + n2];
    }

    public void set(int n, int n2, float f) {
        this.data[4 * n + n2] = f;
    }

    public void setTranslation(Vec3f vec3f) {
        this.set(0, 3, vec3f.x());
        this.set(1, 3, vec3f.y());
        this.set(2, 3, vec3f.z());
    }

    public void setRotation(Rotf rotf) {
        rotf.toMatrix(this);
    }

    public void setRotation(Vec3f vec3f, Vec3f vec3f2, Vec3f vec3f3) {
        this.set(0, 0, vec3f.x());
        this.set(1, 0, vec3f.y());
        this.set(2, 0, vec3f.z());
        this.set(0, 1, vec3f2.x());
        this.set(1, 1, vec3f2.y());
        this.set(2, 1, vec3f2.z());
        this.set(0, 2, vec3f3.x());
        this.set(1, 2, vec3f3.y());
        this.set(2, 2, vec3f3.z());
    }

    public void getRotation(Rotf rotf) {
        rotf.fromMatrix(this);
    }

    public void setScale(Vec3f vec3f) {
        this.set(0, 0, vec3f.x());
        this.set(1, 1, vec3f.y());
        this.set(2, 2, vec3f.z());
    }

    public void invertRigid() {
        float f = this.get(0, 1);
        this.set(0, 1, this.get(1, 0));
        this.set(1, 0, f);
        f = this.get(0, 2);
        this.set(0, 2, this.get(2, 0));
        this.set(2, 0, f);
        f = this.get(1, 2);
        this.set(1, 2, this.get(2, 1));
        this.set(2, 1, f);
        Vec3f vec3f = new Vec3f(-this.get(0, 3), -this.get(1, 3), -this.get(2, 3));
        Vec3f vec3f2 = new Vec3f();
        this.xformDir(vec3f, vec3f2);
        this.set(0, 3, vec3f2.x());
        this.set(1, 3, vec3f2.y());
        this.set(2, 3, vec3f2.z());
    }

    public Mat4f mul(Mat4f mat4f) {
        Mat4f mat4f2 = new Mat4f();
        mat4f2.mul(this, mat4f);
        return mat4f2;
    }

    public void mul(Mat4f mat4f, Mat4f mat4f2) {
        for (int i = 0; i < 4; ++i) {
            for (int j = 0; j < 4; ++j) {
                float f = 0.0f;
                for (int k = 0; k < 4; ++k) {
                    f += mat4f.get(i, k) * mat4f2.get(k, j);
                }
                this.set(i, j, f);
            }
        }
    }

    public void transpose() {
        for (int i = 0; i < 4; ++i) {
            for (int j = 0; j < i; ++j) {
                float f = this.get(i, j);
                this.set(i, j, this.get(j, i));
                this.set(j, i, f);
            }
        }
    }

    public void xformVec(Vec4f vec4f, Vec4f vec4f2) {
        for (int i = 0; i < 4; ++i) {
            float f = 0.0f;
            for (int j = 0; j < 4; ++j) {
                f += this.get(i, j) * vec4f.get(j);
            }
            vec4f2.set(i, f);
        }
    }

    public void xformPt(Vec3f vec3f, Vec3f vec3f2) {
        for (int i = 0; i < 3; ++i) {
            float f = 0.0f;
            for (int j = 0; j < 3; ++j) {
                f += this.get(i, j) * vec3f.get(j);
            }
            vec3f2.set(i, f += this.get(i, 3));
        }
    }

    public void xformDir(Vec3f vec3f, Vec3f vec3f2) {
        for (int i = 0; i < 3; ++i) {
            float f = 0.0f;
            for (int j = 0; j < 3; ++j) {
                f += this.get(i, j) * vec3f.get(j);
            }
            vec3f2.set(i, f);
        }
    }

    public void getColumnMajorData(float[] fArray) {
        for (int i = 0; i < 4; ++i) {
            for (int j = 0; j < 4; ++j) {
                fArray[4 * j + i] = this.get(i, j);
            }
        }
    }

    public Matf toMatf() {
        Matf matf = new Matf(4, 4);
        for (int i = 0; i < 4; ++i) {
            for (int j = 0; j < 4; ++j) {
                matf.set(i, j, this.get(i, j));
            }
        }
        return matf;
    }

    public String toString() {
        String string = System.getProperty("line.separator");
        return "(" + this.get(0, 0) + ", " + this.get(0, 1) + ", " + this.get(0, 2) + ", " + this.get(0, 3) + string + this.get(1, 0) + ", " + this.get(1, 1) + ", " + this.get(1, 2) + ", " + this.get(1, 3) + string + this.get(2, 0) + ", " + this.get(2, 1) + ", " + this.get(2, 2) + ", " + this.get(2, 3) + string + this.get(3, 0) + ", " + this.get(3, 1) + ", " + this.get(3, 2) + ", " + this.get(3, 3) + ")";
    }
}

