/*
 * Decompiled with CFR 0.152.
 */
package gleem.linalg;

import gleem.linalg.Vec3f;

public class MathUtil {
    public static final float FLT_EPSILON = 1.1920929E-7f;
    public static final double EPSILON = 2.220446049250313E-16;
    public static final float ZERO_TOLERANCE = 1.0E-4f;

    public static boolean makePerpendicular(Vec3f vec3f, Vec3f vec3f2) {
        if (vec3f.x() == 0.0f && vec3f.y() == 0.0f && vec3f.z() == 0.0f) {
            return false;
        }
        if (vec3f.x() != 0.0f) {
            if (vec3f.y() != 0.0f) {
                vec3f2.set(-vec3f.y(), vec3f.x(), 0.0f);
            } else {
                vec3f2.set(-vec3f.z(), 0.0f, vec3f.x());
            }
        } else {
            vec3f2.set(1.0f, 0.0f, 0.0f);
        }
        return true;
    }

    public static int sgn(float f) {
        if (f > 0.0f) {
            return 1;
        }
        if (f < 0.0f) {
            return -1;
        }
        return 0;
    }

    public static float clamp(float f, float f2, float f3) {
        if (f < f2) {
            return f2;
        }
        if (f > f3) {
            return f3;
        }
        return f;
    }

    public static int clamp(int n, int n2, int n3) {
        if (n < n2) {
            return n2;
        }
        if (n > n3) {
            return n3;
        }
        return n;
    }
}

