/*
 * Decompiled with CFR 0.152.
 */
package gleem.linalg;

import gleem.linalg.IntersectionPoint;
import gleem.linalg.Vec3f;

public class Plane {
    private Vec3f normal;
    private Vec3f point;
    float c;

    public Plane() {
        this.normal = new Vec3f(0.0f, 1.0f, 0.0f);
        this.point = new Vec3f(0.0f, 0.0f, 0.0f);
        this.recalc();
    }

    public Plane(Vec3f vec3f, Vec3f vec3f2) {
        this.normal = new Vec3f(vec3f);
        this.normal.normalize();
        this.point = new Vec3f(vec3f2);
        this.recalc();
    }

    public void setNormal(Vec3f vec3f) {
        this.normal.set(vec3f);
        this.normal.normalize();
        this.recalc();
    }

    public Vec3f getNormal() {
        return this.normal;
    }

    public void setPoint(Vec3f vec3f) {
        this.point.set(vec3f);
        this.recalc();
    }

    public Vec3f getPoint() {
        return this.point;
    }

    public void projectPoint(Vec3f vec3f, Vec3f vec3f2) {
        float f = this.normal.dot(vec3f) - this.c;
        vec3f2.set(vec3f.minus(this.normal.times(this.normal.dot(this.point) - this.c)));
    }

    public boolean intersectRay(Vec3f vec3f, Vec3f vec3f2, IntersectionPoint intersectionPoint) {
        float f = this.normal.dot(vec3f2);
        if (f == 0.0f) {
            return false;
        }
        intersectionPoint.setT((this.c - this.normal.dot(vec3f)) / f);
        intersectionPoint.setIntersectionPoint(vec3f.plus(vec3f2.times(intersectionPoint.getT())));
        return true;
    }

    private void recalc() {
        this.c = this.normal.dot(this.point);
    }
}

