/*
 * Decompiled with CFR 0.152.
 */
package gleem.linalg;

import gleem.linalg.Vecf;

public class Vec2f {
    private float x;
    private float y;

    public Vec2f() {
    }

    public Vec2f(Vec2f vec2f) {
        this(vec2f.x, vec2f.y);
    }

    public Vec2f(float f, float f2) {
        this.set(f, f2);
    }

    public Vec2f copy() {
        return new Vec2f(this);
    }

    public void set(Vec2f vec2f) {
        this.set(vec2f.x, vec2f.y);
    }

    public void set(float f, float f2) {
        this.x = f;
        this.y = f2;
    }

    public void set(int n, float f) {
        switch (n) {
            case 0: {
                this.x = f;
                break;
            }
            case 1: {
                this.y = f;
                break;
            }
            default: {
                throw new IndexOutOfBoundsException();
            }
        }
    }

    public float get(int n) {
        switch (n) {
            case 0: {
                return this.x;
            }
            case 1: {
                return this.y;
            }
        }
        throw new IndexOutOfBoundsException();
    }

    public float x() {
        return this.x;
    }

    public float y() {
        return this.y;
    }

    public void setX(float f) {
        this.x = f;
    }

    public void setY(float f) {
        this.y = f;
    }

    public float dot(Vec2f vec2f) {
        return this.x * vec2f.x + this.y * vec2f.y;
    }

    public float length() {
        return (float)Math.sqrt(this.lengthSquared());
    }

    public float lengthSquared() {
        return this.dot(this);
    }

    public void normalize() {
        float f = this.length();
        if (f == 0.0f) {
            return;
        }
        this.scale(1.0f / f);
    }

    public Vec2f times(float f) {
        Vec2f vec2f = new Vec2f(this);
        vec2f.scale(f);
        return vec2f;
    }

    public void scale(float f) {
        this.x *= f;
        this.y *= f;
    }

    public Vec2f plus(Vec2f vec2f) {
        Vec2f vec2f2 = new Vec2f();
        vec2f2.add(this, vec2f);
        return vec2f2;
    }

    public void add(Vec2f vec2f) {
        this.add(this, vec2f);
    }

    public void add(Vec2f vec2f, Vec2f vec2f2) {
        this.x = vec2f.x + vec2f2.x;
        this.y = vec2f.y + vec2f2.y;
    }

    public Vec2f addScaled(float f, Vec2f vec2f) {
        Vec2f vec2f2 = new Vec2f();
        vec2f2.addScaled(this, f, vec2f);
        return vec2f2;
    }

    public void addScaled(Vec2f vec2f, float f, Vec2f vec2f2) {
        this.x = vec2f.x + f * vec2f2.x;
        this.y = vec2f.y + f * vec2f2.y;
    }

    public Vec2f minus(Vec2f vec2f) {
        Vec2f vec2f2 = new Vec2f();
        vec2f2.sub(this, vec2f);
        return vec2f2;
    }

    public void sub(Vec2f vec2f) {
        this.sub(this, vec2f);
    }

    public void sub(Vec2f vec2f, Vec2f vec2f2) {
        this.x = vec2f.x - vec2f2.x;
        this.y = vec2f.y - vec2f2.y;
    }

    public Vecf toVecf() {
        Vecf vecf = new Vecf(2);
        for (int i = 0; i < 2; ++i) {
            vecf.set(i, this.get(i));
        }
        return vecf;
    }

    public String toString() {
        return "(" + this.x + ", " + this.y + ")";
    }
}

